<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'image_id', 'slug', 'description', 'categories', 'images', 'vendors', 'distributor', 'suppliers', 'last_modified_by');

    public function lastModifiedBy()
    {
        return $this->hasOne('App\Models\User');
    }

    public function images()
    {
        return $this->hasMany('App\Models\File');
    }

}